' Cosmic Courier (game for CVBasic)
'
' A unique delivery challenge in space.
'
' Creation date: Mar/12/2025.
'
DEFINE SPRITE 0,4,sprites_bitmaps

DIM package_x, package_y, package_active
DIM delivery_x, delivery_y
DIM enemy_x(3), enemy_y(3)
DIM lives

restart_game:
CLS

#score = 0
lives = 3
GOSUB update_score
GOSUB update_lives

player_x = 120
player_y = 176
package_active = 0

package_x = 120
package_y = 176

delivery_x = RANDOM(240)
delivery_y = 32

' Initialize enemies
FOR i = 0 TO 2
    enemy_x(i) = RANDOM(240)
    enemy_y(i) = RANDOM(120) + 32
NEXT i

game_loop:
WAIT

' Background ambiance sound
#c = 940
IF FRAME AND 16 THEN #c = 1023
SOUND 0,#c,15-(FRAME AND 15)

' Setup player sprite as a person
SPRITE 0,player_y-1,player_x,0,2

' Display package as a package if not carried
IF package_active = 0 THEN
    SPRITE 1, package_y, package_x, 8, 2
ELSE
    SPRITE 1, player_y-8, player_x, 8, 2
END IF

' Display delivery point as a box
SPRITE 2, delivery_y, delivery_x, 6, 3

' Display enemies
FOR i = 0 TO 2
    SPRITE i + 4, enemy_y(i), enemy_x(i), 12, 4
    enemy_y(i) = enemy_y(i) + 1
    IF enemy_y(i) > 192 THEN
        enemy_x(i) = RANDOM(240)
        enemy_y(i) = 32
    END IF
    ' Check collision with player
    IF ABS(player_x - enemy_x(i)) < 8 AND ABS(player_y - enemy_y(i)) < 8 THEN
        lives = lives - 1
        GOSUB update_lives
        IF lives = 0 THEN GOTO game_over
        enemy_x(i) = RANDOM(240)
        enemy_y(i) = 32
    END IF
NEXT i

' Check if package is picked up
IF package_active = 0 THEN
    IF ABS(player_x - package_x) < 8 AND ABS(player_y - package_y) < 8 THEN
        package_active = 1
    END IF
END IF

' Check if package is delivered
IF package_active = 1 THEN
    IF ABS(player_x - delivery_x) < 8 AND ABS(player_y - delivery_y) < 8 THEN
        package_active = 0
        #score = #score + 1
        GOSUB update_score
        package_x = RANDOM(240)
        package_y = RANDOM(120) + 32
        delivery_x = RANDOM(240)
        delivery_y = RANDOM(120) + 32
    END IF
END IF

' Player movement
IF cont1.left THEN IF player_x > 0 THEN player_x = player_x - 2
IF cont1.right THEN IF player_x < 240 THEN player_x = player_x + 2
IF cont1.up THEN IF player_y > 0 THEN player_y = player_y - 2
IF cont1.down THEN IF player_y < 192 THEN player_y = player_y + 2

GOTO game_loop

' Game Over Screen
game_over:
	PRINT AT 11, "GAME OVER"
	SOUND 0,,0
      	SOUND 1,,0
      	SOUND 2,,0
      	SOUND 3,,0
GOTO game_over

' Update score
update_score: PROCEDURE
PRINT AT 2,#score,"0"
END PROCEDURE

' Update lives
update_lives: PROCEDURE
PRINT AT 11, "Lives: ", lives
END PROCEDURE

' Bitmaps for the game (updated for person, package, box, and enemy)
sprites_bitmaps:
' Person sprite
BITMAP ".......XX......."
BITMAP "......XXXX......"
BITMAP "......XXXX......"
BITMAP ".......XX......."
BITMAP ".......XX......."
BITMAP "......X..X......"
BITMAP "......X..X......"
BITMAP ".....X....X....."
BITMAP ".....X....X....."
BITMAP "....XX....XX...."
BITMAP "....XX....XX...."
BITMAP ".....X....X....."
BITMAP ".....X....X....."
BITMAP "....XX....XX...."
BITMAP "...XX......XX..."
BITMAP "..XX........XX.."

' Box (delivery destination) sprite
BITMAP "XX............XX"
BITMAP "..XXXXXXXXXXXX.."
BITMAP "..X..........X.."
BITMAP "..X..........X.."
BITMAP "..X..........X.."
BITMAP "..X..........X.."
BITMAP "..X..........X.."
BITMAP "..X..........X.."
BITMAP "..X..........X.."
BITMAP "..XXXXXXXXXXXX.."
BITMAP "XX............XX"
BITMAP "................"
BITMAP "................"
BITMAP "................"
BITMAP "................"
BITMAP "................"

' Package sprite
BITMAP "................"
BITMAP "..XXXXXXXXXXXX.."
BITMAP "..X..........X.."
BITMAP "..X..XXXXXX..X.."
BITMAP "..X..X....X..X.."
BITMAP "..X..XXXXXX..X.."
BITMAP "..X..........X.."
BITMAP "..XXXXXXXXXXXX.."
BITMAP "................"
BITMAP "................"
BITMAP "................"
BITMAP "................"
BITMAP "................"
BITMAP "................"
BITMAP "................"
BITMAP "................"

' Enemy sprite (asteroid or hazard)
BITMAP "................"
BITMAP "................"
BITMAP "......XXXX......"
BITMAP ".....XXXXXX....."
BITMAP "....XX.XXXXX...."
BITMAP "...XXXXXXX.XX..."
BITMAP "..XXXXXXXXXXXXX."
BITMAP "..XXXXXXXXXXXXX."
BITMAP "..XX.XXXX.XXXX.."
BITMAP "..XXXXXXXXXXX..."
BITMAP "...XX.XXXXX....."
BITMAP "....XXXXXXX....."
BITMAP ".....XXXXX......"
BITMAP "......XX.XX....."
BITMAP ".......XX......."
BITMAP "................"
